/*
 * Toolkit GUI, an application built for operating pinkRF's signal generators.
 *
 * Contact: https://www.pinkrf.com/contact/
 * Copyright © 2018-2024 pinkRF B.V
 * GNU General Public License version 3.
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with this program. If not, see https://www.gnu.org/licenses/
 *
 * Author: Iordan Svechtarov
 */

#ifndef GPIO_CLASS_H
#define GPIO_CLASS_H

#include <QObject>

class GPIOClass : public QObject
{
	Q_OBJECT

public:
	GPIOClass(QString GPIO_BCM_number);
	~GPIOClass();

	bool setDirection(QString direction);
	bool setValue(QString value);
	int readValue();

private:
	bool export_GPIO();
	bool unexport_GPIO();

	QString gpionum;

};

#endif
